clc
clear
close all

set(0,'defaultTextInterpreter','tex');
set(0,'defaultAxesFontSize',10);

%% Geometria
% Reference Design params
deltaRif = 5/22.6;              % delta=h2/h0
alfaRif = 20;                   % è il complementare a 90° di teta, indicato da Whipple
GammaRif = 20/33;               % =rb/r2
gammaRif = 5.5/11;              % a2/a1

% Design params
delta = linspace(0.2,1,100);            %delta=h2/h0
alfa = linspace(10,70,100);             %è il complementare a 90° di teta, indicato da Whipple
Gamma = linspace(0.6,0.9,100);          %=rb/r2
gamma = linspace(0.2,2,100);         	%a2/a1

% Fixed params
h2Rif = 15e-6;                  % fixed air gap above the ridge

h2 = linspace(3,15,50)*1e-6;    % variable air gap above the ridge
% k = 12;                       %numero scanalature
k = 12;                         %numero scanalature Pauri
r1 = 16e-3;                     %raggio interno
r2 = 33e-3;                     %raggio esterno


p0 = 1e5;               %ambient pressure
mu = 1.81e-5;           %viscosità dinamica dell'aria a 20°C [Ns/m^2]
rho = 1.2;              %kg/m^3
n = 70000;             %rpm

% Calcolo grandezze derivate dai design params
% h0 = h2./delta;           %groove depth
% rb = r2.*Capital_gamma;    %raggio fine groove
% h1 = h2+h0;
% a1=2*pi*r2/k/(1+gamma); %misurati sul raggio esterno
% a2=2*pi*r2/k-a1;
%  d=r2-rb; %estensione parte scanalata (lungo il raggio)
%  c=rb-r1; %estensione parte non scanalata (lungo il raggio)
% H = h2/h1;


%% Ottimizzzione

%Variabili: x(1) = alfa; x(2) = gamma; x(3) = Capital_gamma; x(4) = delta
f = @(x) -1* MJM_paper(x(1),x(2),x(3),x(4),n,h2Rif,r1,r2,mu,rho);       % N
x0 = [alfaRif gammaRif GammaRif deltaRif];                              % initial guess
xmax = fmincon(f,x0,[],[],[],[],[10 0.2 0.6 0.2],[70 2 0.9 1]);         % minimize negative function
W_Muij_max = -f(xmax);                                                  % N 

figure
[x1,y1] = meshgrid(alfa,gamma);
% surf(x1,y1,MJM_paper(x1, y1,xmax(3),xmax(4),w_rpm,h2Rif,r1,r2,mu,ro),'EdgeColor','interp');
% surf(x1,y1,MJM_paper(x1, y1,xmax(3),xmax(4),n,h2Rif,r1,r2,mu,rho));
surf(x1,y1,MJM_paper(x1, y1,xmax(3),xmax(4),n,h2Rif,r1,r2,mu,rho),'EdgeColor','interp');
% mesh(x1,y1,MJM_paper(x1, y1,xmax(3),xmax(4),n,h2Rif,r1,r2,mu,rho));
xlabel('\alpha(°)')
ylabel('\gamma')
zlabel('W (N)')
hold on
plot3(xmax(1),xmax(2),W_Muij_max,'.k','MarkerSize',20)

figure
[x2,y2] = meshgrid(Gamma,delta);
% surf(x2,y2,MJM_paper(xmax(1),xmax(2),x2,y2,n,h2Rif,r1,r2,mu,rho));
surf(x2,y2,MJM_paper(xmax(1),xmax(2),x2,y2,n,h2Rif,r1,r2,mu,rho),'EdgeColor','interp');
xlabel('\Gamma')
ylabel('\delta')
zlabel('W (N)')
hold on
plot3(xmax(3),xmax(4),W_Muij_max,'.k','MarkerSize',20)

